/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.dialog;

import filenet.vw.api.VWReturnStackElement;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWFieldsCellRenderer;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class VWInformationStackDialog
extends JDialog
implements ActionListener {
    private Frame m_parentFrame = null;
    private Vector m_wobsList = new Vector();
    private Vector m_vErrors = new Vector();
    private JButton m_closeButton = null;
    private JButton m_helpButton = null;
    private VWTable m_infoStackTable = null;
    private InfoStackTableModel m_infoStackTableModel = null;
    private VWTable m_selectionTable = null;
    private SelectionTableModel m_selectionTableModel = null;
    private Font m_plainFont = null;

    public VWInformationStackDialog(Vector selectedWork, Frame parentFrame) {
        super(parentFrame);
        this.m_parentFrame = parentFrame;
        this.m_wobsList = selectedWork;
        Font font = this.getFont();
        if (font != null) {
            this.m_plainFont = new Font(font.getName(), 0, font.getSize());
        }
        this.getContentPane().setLayout(new BorderLayout(6, 6));
        Dimension dim = VWStringUtils.stringToDimension(VWResource.s_informationStackDialogDim);
        if (dim == null) {
            dim = new Dimension(500, 450);
        }
        this.setSize(dim.width, dim.height);
        this.setTitle(VWResource.s_informationStackTitle);
        this.setVisible(false);
        this.setLocationRelativeTo(this.m_parentFrame);
        this.getContentPane().add((Component)this.createMainPanel(), "Center");
        this.getContentPane().add((Component)this.createButtonPanel(), "Last");
        ComponentOrientation o = ComponentOrientation.getOrientation(Locale.getDefault());
        this.getContentPane().applyComponentOrientation(o);
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.m_closeButton) {
            this.doCleanup();
            this.setVisible(false);
        } else if (object == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_General + "bpfcg015.htm");
        }
    }

    public void removeReferences() {
        if (this.m_infoStackTableModel != null) {
            this.m_infoStackTableModel.removeReferences();
            this.m_infoStackTableModel = null;
        }
        if (this.m_selectionTableModel != null) {
            this.m_selectionTableModel.removeReferences();
            this.m_selectionTableModel = null;
        }
        this.dispose();
    }

    public void updateDialog(Vector wobsList) {
        this.m_selectionTableModel = new SelectionTableModel(wobsList);
        this.m_selectionTable.setModel(this.m_selectionTableModel);
        this.m_infoStackTable.setModel(new DefaultTableModel());
    }

    private JPanel createMainPanel() {
        JPanel mainPanel = new JPanel();
        try {
            JPanel participantsAndInfoStackPanel = new JPanel();
            this.setupParticipantsAndInfoStackPanel(participantsAndInfoStackPanel);
            mainPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            mainPanel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(2, 2, 2, 2);
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 23;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            mainPanel.add((Component)participantsAndInfoStackPanel, c);
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel setupParticipantsAndInfoStackPanel(JPanel panel) {
        try {
            this.m_selectionTable = new VWTable(new DefaultTableModel());
            this.m_selectionTable.setPreferredScrollableViewportSize(new Dimension(500, 100));
            this.m_selectionTable.setShowGrid(false);
            this.m_selectionTable.setRowSelectionAllowed(true);
            JScrollPane scrollPane1 = new JScrollPane(this.m_selectionTable);
            this.m_selectionTableModel = new SelectionTableModel(this.m_wobsList);
            this.m_selectionTable.setModel(this.m_selectionTableModel);
            VWAccessibilityHelper.setAccessibility(this.m_selectionTable, this, VWResource.s_workItemsTable, VWResource.s_workItemsTable);
            this.addListenerForRowSelectionChanged();
            this.m_selectionTable.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    if (VWInformationStackDialog.this.m_selectionTable == null || VWInformationStackDialog.this.m_selectionTable.getModel() == null || VWInformationStackDialog.this.m_selectionTable.getRowCount() == 0) {
                        FocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                    }
                }
            });
            this.m_infoStackTable = new VWTable(new DefaultTableModel());
            this.m_infoStackTable.setPreferredScrollableViewportSize(new Dimension(500, 100));
            this.m_infoStackTable.setShowGrid(false);
            this.m_infoStackTable.setRowSelectionAllowed(false);
            VWAccessibilityHelper.setAccessibility(this.m_infoStackTable, this, VWResource.s_infoStackTable, VWResource.s_infoStackTable);
            JScrollPane scrollPane2 = new JScrollPane(this.m_infoStackTable);
            this.m_infoStackTable.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    if (VWInformationStackDialog.this.m_infoStackTable == null || VWInformationStackDialog.this.m_infoStackTable.getModel() == null || VWInformationStackDialog.this.m_infoStackTable.getRowCount() == 0) {
                        FocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                    }
                }
            });
            panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            panel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.anchor = 21;
            c.fill = 0;
            c.insets = new Insets(4, 4, 4, 4);
            c.ipadx = 0;
            c.ipady = 0;
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 23;
            c.gridwidth = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            JLabel selectWork = new JLabel(VWResource.s_selectTableLabelInInfoStackDlg);
            panel.add((Component)selectWork, c);
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 0;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.insets = new Insets(4, 4, 20, 4);
            panel.add((Component)scrollPane1, c);
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 1;
            c.fill = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.insets = new Insets(4, 4, 4, 4);
            JLabel infoStackTableLabel = new JLabel(VWResource.s_informationStackColon);
            panel.add((Component)infoStackTableLabel, c);
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 0;
            c.gridheight = 1;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            panel.add((Component)scrollPane2, c);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = null;
        GridBagConstraints gbCons = null;
        try {
            buttonPanel = new JPanel(new GridBagLayout());
            gbCons = new GridBagConstraints();
            gbCons.anchor = 10;
            gbCons.fill = 0;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(1, 2, 6, 6);
            this.m_closeButton = new JButton(VWResource.s_close);
            this.m_closeButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_closeButton, this, VWResource.s_close, VWResource.s_close);
            this.m_closeButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_closeButton, gbCons);
            ++gbCons.gridx;
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, this, VWResource.s_help, VWResource.s_help);
            this.m_helpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_helpButton, gbCons);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void refreshInfoStackTable(VWWorkObject wob) {
        try {
            this.m_infoStackTableModel = new InfoStackTableModel(wob);
            this.m_infoStackTable.setModel(this.m_infoStackTableModel);
            this.setupInfoStackTableColumns();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void setupInfoStackTableColumns() {
        int nColWidth = 0;
        try {
            if (this.m_infoStackTable == null) {
                return;
            }
            if (!(this.m_infoStackTable.getModel() instanceof InfoStackTableModel)) {
                return;
            }
            TableColumnModel columnModel = this.m_infoStackTable.getColumnModel();
            TableColumn aColumn = this.m_infoStackTable.getColumn(VWResource.s_map);
            try {
                nColWidth = Integer.valueOf(VWResource.InfoStackPanMapWidth);
                aColumn.setCellRenderer(new VWFieldsCellRenderer());
            }
            catch (Exception ex) {
                nColWidth = 90;
            }
            aColumn.setMinWidth(nColWidth);
            aColumn.setWidth(nColWidth);
            aColumn = this.m_infoStackTable.getColumn(VWResource.s_stepLabel);
            try {
                nColWidth = Integer.valueOf(VWResource.InfoStackPanStepWidth);
                aColumn.setCellRenderer(new VWFieldsCellRenderer());
            }
            catch (Exception ex) {
                nColWidth = 90;
            }
            aColumn.setMinWidth(nColWidth);
            aColumn.setWidth(nColWidth);
            aColumn = this.m_infoStackTable.getColumn(VWResource.s_errorNumber);
            try {
                nColWidth = Integer.valueOf(VWResource.InfoStackPanErrorNumWidth);
                aColumn.setCellRenderer(new VWFieldsCellRenderer());
            }
            catch (Exception ex) {
                nColWidth = 90;
            }
            aColumn.setMinWidth(nColWidth);
            aColumn.setWidth(nColWidth);
            aColumn = this.m_infoStackTable.getColumn(VWResource.s_errorMessage);
            try {
                nColWidth = Integer.valueOf(VWResource.InfoStackPanErrorMsgWidth);
                aColumn.setCellRenderer(new VWFieldsCellRenderer());
            }
            catch (Exception ex) {
                nColWidth = 250;
            }
            aColumn.setMinWidth(nColWidth);
            aColumn.setWidth(nColWidth);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void addListenerForRowSelectionChanged() {
        ListSelectionModel rowSM = this.m_selectionTable.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty() && !e.getValueIsAdjusting()) {
                    VWWorkObject wob = (VWWorkObject)VWInformationStackDialog.this.m_selectionTableModel.getObjectAt(VWInformationStackDialog.this.m_selectionTable.getSelectedRow());
                    VWInformationStackDialog.this.refreshInfoStackTable(wob);
                }
            }
        });
    }

    private void doCleanup() {
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
        this.removeReferences();
    }

    class InfoStackTableModel
    extends AbstractTableModel {
        private Vector m_columnNames = new Vector();
        private Vector m_rowCache = new Vector();
        private VWWorkObject m_wob = null;
        private VWReturnStackElement[] m_infoStackObjects = null;

        public InfoStackTableModel(VWWorkObject wob) {
            if (wob == null) {
                return;
            }
            this.m_wob = wob;
            try {
                this.m_infoStackObjects = this.m_wob.fetchReturnStackElements();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
            this.initColumns();
            this.initRowData();
        }

        public int getColumnCount() {
            return this.m_columnNames.size();
        }

        public int getRowCount() {
            return this.m_rowCache.size();
        }

        public String getColumnName(int col) {
            if (col < this.getColumnCount()) {
                return (String)this.m_columnNames.elementAt(col);
            }
            return null;
        }

        public Object getValueAt(int row, int col) {
            Vector rowData = (Vector)this.m_rowCache.elementAt(row);
            if (rowData != null) {
                return rowData.elementAt(col);
            }
            return null;
        }

        protected void removeReferences() {
            if (this.m_rowCache != null) {
                this.m_rowCache.removeAllElements();
            }
            if (this.m_columnNames != null) {
                this.m_columnNames.removeAllElements();
                this.m_columnNames = null;
            }
        }

        private void initColumns() {
            this.m_columnNames.addElement(VWResource.s_map);
            this.m_columnNames.addElement(VWResource.s_stepLabel);
            this.m_columnNames.addElement(VWResource.s_errorNumber);
            this.m_columnNames.addElement(VWResource.s_errorMessage);
        }

        private void initRowData() {
            try {
                this.m_rowCache.removeAllElements();
                if (this.m_infoStackObjects != null) {
                    for (int i = 0; i < this.m_infoStackObjects.length; ++i) {
                        Vector<String> rowData = new Vector<String>();
                        rowData.addElement(this.m_infoStackObjects[i].getMapName());
                        rowData.addElement(this.m_infoStackObjects[i].getStepName());
                        rowData.addElement(this.m_infoStackObjects[i].getErrorNumber());
                        rowData.addElement(this.m_infoStackObjects[i].getErrorMessageText());
                        this.m_rowCache.addElement(rowData);
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    class SelectionTableModel
    extends AbstractTableModel {
        private Vector m_columnNames = new Vector();
        private Vector m_objectCache = new Vector();
        private Vector m_rowCache = new Vector();
        private Vector m_wobsList;

        public SelectionTableModel(Vector wobsList) {
            this.m_wobsList = wobsList;
            this.initObjectCache();
            this.initColumns();
            this.initRowData();
        }

        public int getColumnCount() {
            return this.m_columnNames.size();
        }

        public int getRowCount() {
            return this.m_rowCache.size();
        }

        public String getColumnName(int col) {
            if (col < this.getColumnCount()) {
                return (String)this.m_columnNames.elementAt(col);
            }
            return null;
        }

        public Object getValueAt(int row, int col) {
            Vector rowData = (Vector)this.m_rowCache.elementAt(row);
            if (rowData != null) {
                return rowData.elementAt(col);
            }
            return null;
        }

        public Object getObjectAt(int rowIndex) {
            VWWorkObject obj = null;
            if (rowIndex > this.getRowCount() - 1) {
                return null;
            }
            obj = (VWWorkObject)this.m_objectCache.elementAt(rowIndex);
            return obj;
        }

        private void initColumns() {
            this.m_columnNames.addElement(VWResource.s_participantName);
            this.m_columnNames.addElement(VWResource.s_queue);
            this.m_columnNames.addElement(VWResource.s_stepLabel);
            this.m_columnNames.addElement(VWResource.s_subject);
            this.m_columnNames.addElement(VWResource.s_status);
        }

        protected void initObjectCache() {
            VWWorkObject curWorkObject = null;
            try {
                if (this.m_objectCache != null) {
                    this.m_objectCache.removeAllElements();
                }
                for (int rowNum = 0; rowNum < this.m_wobsList.size() && (curWorkObject = (VWWorkObject)this.m_wobsList.elementAt(rowNum)) != null; ++rowNum) {
                    this.m_objectCache.addElement(curWorkObject);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }

        private void initRowData() {
            Vector<String> rowData = null;
            try {
                if (this.m_rowCache != null) {
                    this.m_rowCache.removeAllElements();
                }
                for (int i = 0; i < this.m_objectCache.size(); ++i) {
                    VWWorkObject curWorkObject = (VWWorkObject)this.m_objectCache.elementAt(i);
                    rowData = new Vector<String>();
                    rowData.addElement(curWorkObject.getParticipantName());
                    rowData.addElement(curWorkObject.getCurrentQueueName());
                    rowData.addElement(curWorkObject.getStepName());
                    rowData.addElement(curWorkObject.getSubject());
                    String statusStr = VWResource.s_inProgress;
                    String errorNumberStr = curWorkObject.getLastErrorNumber();
                    if (errorNumberStr != null && VWStringUtils.compare(errorNumberStr, "0") != 0) {
                        statusStr = VWResource.s_exception;
                    }
                    rowData.addElement(statusStr);
                    this.m_rowCache.addElement(rowData);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }

        private void removeReferences() {
            if (this.m_rowCache != null) {
                this.m_rowCache.removeAllElements();
            }
            if (this.m_wobsList != null) {
                this.m_wobsList.removeAllElements();
                this.m_wobsList = null;
            }
            if (this.m_columnNames != null) {
                this.m_columnNames.removeAllElements();
                this.m_columnNames = null;
            }
        }
    }
}

